<script>
    document.addEventListener("DOMContentLoaded", function () {

        const searchInput = document.getElementById("searchInput");
        const suggestionBox = document.getElementById("suggestionBox");

        let suggestions = []; // Will load later (async)

        // Load JSON asynchronously
        fetch("<?php echo get_template_directory_uri(); ?>/plugins-suggestions.json")
            .then(res => res.json())
            .then(data => {
                suggestions = data;
            });

        // Fuzzy match function
        function fuzzyMatch(str, query) {
            str = str.toLowerCase();
            query = query.toLowerCase();

            const words = query.split(/\s+/).filter(w => w.length);

            return words.every(word => {
                if (word.length <= 2) {
                    return str.includes(word);
                }

                // fuzzy: first 60% of the word
                const part = word.slice(0, Math.ceil(word.length * 0.6));

                // must match ANYWHERE in the string
                return str.includes(part);
            });
        }

        // Highlight function with Tailwind styling
        function highlight(text, query) {
            if (!query.trim()) return text;

            let words = query.split(/\s+/).filter(w => w.length > 1);

            words.forEach(word => {

                // fuzzy short match (60%)
                const short = word.slice(0, Math.ceil(word.length * 0.6));

                // If FULL word exists → highlight full word
                let pattern;
                if (text.toLowerCase().includes(word.toLowerCase())) {
                    pattern = word; // full highlight
                } else {
                    pattern = short; // fuzzy highlight
                }

                // match only outside HTML tags
                const reg = new RegExp(`(${pattern})(?!(?:[^<]*?>))`, "gi");

                text = text.replace(
                    reg,
                    '<span class="inline-block bg-yellow-200 text-red-600 px-1 rounded">$1</span>'
                );
            });

            return text;
        }

        // Render dropdown list
        function renderSuggestionList(list, query) {
            if (!list.length) {
                suggestionBox.innerHTML = `<div class="px-4 py-3 text-sm text-gray-500">No results found</div>`;
                return;
            }

            suggestionBox.innerHTML = list.map(item => `
            <a href="${item.link}"
               class="block px-4 py-3 hover:bg-gray-100 cursor-pointer text-sm">
               <span class="font-medium">${highlight(item.title, query)}</span><br>
               <span class="text-gray-500 text-xs">${highlight(item.text, query)}</span>
            </a>
        `).join("");
        }

        // Input event
        searchInput.addEventListener("input", () => {
            const q = searchInput.value.trim().toLowerCase();
            if (!q) {
                suggestionBox.classList.add("hidden");
                return;
            }

            const filtered = suggestions.filter(item =>
                fuzzyMatch(item.title, q) ||
                fuzzyMatch(item.text, q)
            );

            renderSuggestionList(filtered, q);
            suggestionBox.classList.toggle("hidden", filtered.length === 0);
        });

        // Focus event
        searchInput.addEventListener("focus", () => {
            if (suggestions.length > 0) {
                renderSuggestionList(suggestions, "");
                suggestionBox.classList.remove("hidden");
            }
        });

        // Hide on outside click
        document.addEventListener("click", (e) => {
            if (!e.target.closest(".search-wrapper")) {
                suggestionBox.classList.add("hidden");
            }
        });

    });
    jQuery(function ($) {

        function triggerFuzzySearch() {
            var searchText = $('#searchInput').val();

            if (!searchText.trim()) {
                return;
            }

            var fuzzy_url = "<?php echo site_url(); ?>/fuzzy-search/?text=" + encodeURIComponent(searchText);
            window.location.href = fuzzy_url;
        }

        // Click event
        $('.home_fuzzy_search').on('click', function (e) {
            e.preventDefault();
            triggerFuzzySearch();
        });

        // Enter key event
        $('#searchInput').on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                triggerFuzzySearch();
            }
        });

    });

</script>